//
//  ViewController.m
//  Listening and Reacting to Keyboard Notifications
//
//  Created by Vandad Nahavandipoor on 23/08/2011.
//  Copyright (c) 2011 Pixolity Ltd. All rights reserved.
//

/* 1 */
//#import "ViewController.h"
//
//@implementation ViewController
//
//@synthesize myTableView;
//
//- (NSInteger) numberOfSectionsInTableView:(UITableView *)tableView{
//  return 1;
//}
//
//- (NSInteger) tableView:(UITableView *)tableView 
//  numberOfRowsInSection:(NSInteger)section{
//  return 100;
//}
//
//- (UITableViewCell *) tableView:(UITableView *)tableView 
//          cellForRowAtIndexPath:(NSIndexPath *)indexPath{
//  
//  UITableViewCell *result = nil;
//  
//  static NSString *CellIdentifier = @"CellIdentifier";
//  
//  result = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
//  
//  if (result == nil){
//    result = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
//                                    reuseIdentifier:CellIdentifier];
//  }
//  
//  result.textLabel.text = [NSString stringWithFormat:
//                           @"Komórka %ld", (long)indexPath.row];
//  
//  CGRect accessoryRect = CGRectMake(0.0f,
//                                    0.0f,
//                                    150.0f,
//                                    31.0f);
//  
//  UITextField *accesssory = [[UITextField alloc] initWithFrame:accessoryRect];
//  accesssory.borderStyle = UITextBorderStyleRoundedRect;
//  accesssory.contentVerticalAlignment = UIControlContentVerticalAlignmentCenter;
//  accesssory.placeholder = @"Podaj dowolny tekst";
//  result.accessoryView = accesssory;
//  
//  return result;
//  
//}
//
//- (void)viewDidLoad{
//  [super viewDidLoad];
//
//  self.myTableView = [[UITableView alloc] 
//                      initWithFrame:self.view.bounds
//                      style:UITableViewStyleGrouped];
//  
//  self.myTableView.delegate = self;
//  self.myTableView.dataSource = self;
//  [self.view addSubview:self.myTableView];
//  
//}
//
//- (void)viewDidUnload{
//  [self setMyTableView:nil];
//  [super viewDidUnload];
//}
//
//- (BOOL)shouldAutorotateToInterfaceOrientation
//        :(UIInterfaceOrientation)interfaceOrientation{
//  return YES;
//}
//
//@end

/* 2 */
#import "ViewController.h"
//#import <CoreGraphics/CoreGraphics.h>

@implementation ViewController

@synthesize myTableView;

- (BOOL)textFieldShouldReturn:(UITextField *)textField{
  /* Upewniamy się, że klawisz Gotowe na klawiaturze spowoduje w każdym polu tekstowym
   (widoku pomocniczym każdej komórki) usunięcie klawiatury z ekranu. */
  [textField resignFirstResponder];
  return YES;
}

- (NSInteger) numberOfSectionsInTableView:(UITableView *)tableView{
  return 1;
}

- (NSInteger) tableView:(UITableView *)tableView 
  numberOfRowsInSection:(NSInteger)section{
  return 100;
}

- (UITableViewCell *) tableView:(UITableView *)tableView 
          cellForRowAtIndexPath:(NSIndexPath *)indexPath{
  
  UITableViewCell *result = nil;
  
  static NSString *CellIdentifier = @"CellIdentifier";
  
  result = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
  
  if (result == nil){
    result = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
                                    reuseIdentifier:CellIdentifier];
    result.selectionStyle = UITableViewCellSelectionStyleNone;
  }
  
  result.textLabel.text = [NSString stringWithFormat:
                           @"Komórka %ld", (long)indexPath.row];
  
  CGRect accessoryRect = CGRectMake(0.0f,
                                    0.0f,
                                    150.0f,
                                    31.0f);
  
  UITextField *accesssory = [[UITextField alloc] initWithFrame:accessoryRect];
  accesssory.borderStyle = UITextBorderStyleRoundedRect;
  accesssory.contentVerticalAlignment = UIControlContentVerticalAlignmentCenter;
  accesssory.placeholder = @"Podaj dowolny tekst";
  accesssory.delegate = self;
  result.accessoryView = accesssory;
  
  return result;
  
}

- (void) handleKeyboardWillHide:(NSNotification *)paramNotification{
  
  if (UIEdgeInsetsEqualToEdgeInsets(self.myTableView.contentInset, 
                                    UIEdgeInsetsZero)){
    /* Marginesy treści w widoku tabeli nie zostały zmodyfikowane więc nie trzeba przywracać im wartości domyślnych. */
    return;
  }
  
  NSDictionary *userInfo = [paramNotification userInfo];
  
  NSValue *animationCurveObject = 
  [userInfo valueForKey:UIKeyboardAnimationCurveUserInfoKey];
  
  NSValue *animationDurationObject =
  [userInfo valueForKey:UIKeyboardAnimationDurationUserInfoKey];
  
  NSValue *keyboardEndRectObject = 
  [userInfo valueForKey:UIKeyboardFrameEndUserInfoKey];
  
  NSUInteger animationCurve = 0;
  double animationDuration = 0.0f;
  CGRect keyboardEndRect = CGRectMake(0, 0, 0, 0);
  
  [animationCurveObject getValue:&animationCurve];
  [animationDurationObject getValue:&animationDuration];
  [keyboardEndRectObject getValue:&keyboardEndRect];
  
  [UIView beginAnimations:@"changeTableViewContentInset"
                  context:NULL];
  [UIView setAnimationDuration:animationDuration];
  [UIView setAnimationCurve:(UIViewAnimationCurve)animationCurve];
  
  self.myTableView.contentInset = UIEdgeInsetsZero;
  
  [UIView commitAnimations];
  
}

/* 1 */
//- (void) handleKeyboardWillShow:(NSNotification *)paramNotification{
//  
//  NSDictionary *userInfo = [paramNotification userInfo];
//  
//  NSValue *animationCurveObject = 
//    [userInfo valueForKey:UIKeyboardAnimationCurveUserInfoKey];
//  
//  NSValue *animationDurationObject =
//    [userInfo valueForKey:UIKeyboardAnimationDurationUserInfoKey];
//  
//  NSValue *keyboardEndRectObject = 
//    [userInfo valueForKey:UIKeyboardFrameEndUserInfoKey];
//  
//  NSUInteger animationCurve = 0;
//  double animationDuration = 0.0f;
//  CGRect keyboardEndRect = CGRectMake(0, 0, 0, 0);
//  
//  [animationCurveObject getValue:&animationCurve];
//  [animationDurationObject getValue:&animationDuration];
//  [keyboardEndRectObject getValue:&keyboardEndRect];
//  
//  [UIView beginAnimations:@"changeTableViewContentInset"
//                  context:NULL];
//  [UIView setAnimationDuration:animationDuration];
//  [UIView setAnimationCurve:(UIViewAnimationCurve)animationCurve];
//  
//  UIWindow *window = [[[UIApplication sharedApplication] delegate] window];
//  
//  CGRect intersectionOfKeyboardRectAndWindowRect =
//    CGRectIntersection(window.frame, keyboardEndRect);
//  
//  CGFloat bottomInset = intersectionOfKeyboardRectAndWindowRect.size.height;
//  
//  self.myTableView.contentInset = UIEdgeInsetsMake(0.0f,
//                                                   0.0f,
//                                                   bottomInset,
//                                                   0.0f);
//  
//  NSIndexPath *indexPathOfOwnerCell = nil;
//  /* Upewniamy się, że zaznaczone pole tekstowe jest widoczne na ekranie. */
//  NSInteger numberOfCells = [self.myTableView.dataSource 
//                             tableView:self.myTableView
//                             numberOfRowsInSection:0];
//  
//  /* Przechodzimy przez wszystkie komórki i wyszukujemy ich pola tekstowe.
//   Po zebraniu odniesień do tych pól tekstowych można sprawdzić, które z nich
//   ma przypisany status First Responder (wyświetliło klawiaturę). Następnie w wywołaniu
//   do widoku tabeli upewniamy się, że po wyświetleniu klawiatury, ta konkretna
//   komórka NIE jest zasłonięta przez klawiaturę. */
//  for (NSInteger counter = 0;
//       counter < numberOfCells;
//       counter++){
//    NSIndexPath *indexPath = [NSIndexPath indexPathForRow:counter
//                                                inSection:0];
//    UITableViewCell *cell = [self.myTableView cellForRowAtIndexPath:indexPath];
//    UITextField *textField = (UITextField *)cell.accessoryView;
//    if ([textField isKindOfClass:[UITextField class]] == NO){
//      continue;
//    }
//    if ([textField isFirstResponder]){
//      indexPathOfOwnerCell = indexPath;
//      break;
//    }
//  }
//  
//  [UIView commitAnimations];
//  
//  if (indexPathOfOwnerCell != nil){
//    [self.myTableView scrollToRowAtIndexPath:indexPathOfOwnerCell
//                            atScrollPosition:UITableViewScrollPositionMiddle
//                                    animated:YES];
//  }
//
//}

/* 2 */
- (void) handleKeyboardWillShow:(NSNotification *)paramNotification{
  
  NSDictionary *userInfo = [paramNotification userInfo];
  
  NSValue *animationCurveObject = 
  [userInfo valueForKey:UIKeyboardAnimationCurveUserInfoKey];
  
  NSValue *animationDurationObject =
  [userInfo valueForKey:UIKeyboardAnimationDurationUserInfoKey];
  
  NSValue *keyboardEndRectObject = 
  [userInfo valueForKey:UIKeyboardFrameEndUserInfoKey];
  
  NSUInteger animationCurve = 0;
  double animationDuration = 0.0f;
  CGRect keyboardEndRect = CGRectMake(0, 0, 0, 0);
  
  [animationCurveObject getValue:&animationCurve];
  [animationDurationObject getValue:&animationDuration];
  [keyboardEndRectObject getValue:&keyboardEndRect];
  
  UIWindow *window = [[[UIApplication sharedApplication] delegate] window];
  
  /* Konwersja ramki z systemu współrzędnych okna na system współrzędny widoku. */
  keyboardEndRect = [self.view convertRect:keyboardEndRect
                                  fromView:window];
  
  [UIView beginAnimations:@"changeTableViewContentInset"
                  context:NULL];
  [UIView setAnimationDuration:animationDuration];
  [UIView setAnimationCurve:(UIViewAnimationCurve)animationCurve];
  
  CGRect intersectionOfKeyboardRectAndWindowRect =
  CGRectIntersection(window.frame, keyboardEndRect);
  
  CGFloat bottomInset = intersectionOfKeyboardRectAndWindowRect.size.height;
  
  self.myTableView.contentInset = UIEdgeInsetsMake(0.0f,
                                                   0.0f,
                                                   bottomInset,
                                                   0.0f);
  
  NSIndexPath *indexPathOfOwnerCell = nil;
  /* Upewniamy się, że zaznaczone pole tekstowe jest widoczne na ekranie. */
  NSInteger numberOfCells = [self.myTableView.dataSource 
                             tableView:self.myTableView
                             numberOfRowsInSection:0];
  
    /* Przechodzimy przez wszystkie komórki i wyszukujemy ich pola tekstowe.
     Po zebraniu odniesień do tych pól tekstowych można sprawdzić, które z nich
     ma przypisany status First Responder (wyświetliło klawiaturę). Następnie w wywołaniu
     do widoku tabeli upewniamy się, że po wyświetleniu klawiatury, ta konkretna
     komórka NIE jest zasłonięta przez klawiaturę. */
  for (NSInteger counter = 0;
       counter < numberOfCells;
       counter++){
    NSIndexPath *indexPath = [NSIndexPath indexPathForRow:counter
                                                inSection:0];
    UITableViewCell *cell = [self.myTableView cellForRowAtIndexPath:indexPath];
    UITextField *textField = (UITextField *)cell.accessoryView;
    if ([textField isKindOfClass:[UITextField class]] == NO){
      continue;
    }
    if ([textField isFirstResponder]){
      indexPathOfOwnerCell = indexPath;
      break;
    }
  }
  
  [UIView commitAnimations];
  
  if (indexPathOfOwnerCell != nil){
    [self.myTableView scrollToRowAtIndexPath:indexPathOfOwnerCell
                            atScrollPosition:UITableViewScrollPositionMiddle
                                    animated:YES];
  }
  
}

- (void)viewDidLoad{
  [super viewDidLoad];
  
  self.myTableView = [[UITableView alloc] 
                      initWithFrame:self.view.bounds
                      style:UITableViewStyleGrouped];
  
  self.myTableView.delegate = self;
  self.myTableView.dataSource = self;
  self.myTableView.autoresizingMask = UIViewAutoresizingFlexibleWidth |
                                      UIViewAutoresizingFlexibleHeight;
  [self.view addSubview:self.myTableView];
  
}

- (void)viewDidUnload{
  [self setMyTableView:nil];
  [super viewDidUnload];
}

- (void) viewDidAppear:(BOOL)paramAnimated{
  [super viewDidAppear:paramAnimated];
  
  NSNotificationCenter *center = [NSNotificationCenter defaultCenter];
  
  [center addObserver:self
             selector:@selector(handleKeyboardWillShow:)
                 name:UIKeyboardWillShowNotification
               object:nil];
  [center addObserver:self
             selector:@selector(handleKeyboardWillHide:)
                 name:UIKeyboardWillHideNotification
               object:nil];
  
}

- (void) viewDidDisappear:(BOOL)paramAnimated{
  [super viewDidDisappear:paramAnimated];
  [[NSNotificationCenter defaultCenter] removeObserver:self];
}

- (BOOL)shouldAutorotateToInterfaceOrientation
  :(UIInterfaceOrientation)interfaceOrientation{
  return YES;
}

@end
